package servercore.job;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import lib.io.ByteUtil;
import servercore.html5.WebSocketFrame;
import servercore.http.HttpRequest;
import servercore.http.HttpResponse;
import servercore.servelet.reflect.Action;

public class GeneratePage {
	public static HttpResponse execute(HttpRequest req) {
		return execute(req, null, null);
	}
	public static HttpResponse execute(HttpRequest req, OutputStream ops, InputStream ips) {
		File ifThisIsFile = null;
		HttpResponse res = new HttpResponse();
		String realPath = req.getPath();
		String cgiPath = req.getRowPath();
		cgiPath = cgiPath.replaceAll("\\/", ".");
		String ext = req.getExtesion();
		try {
			if("do".equals(ext)) {
				int index = cgiPath.indexOf(".do");
				String pkg = "refrect_action" + cgiPath.substring(0, index);
				res = executeCgi(req, pkg);
				return res;
			} else if("ws".equals(ext)) {
				int index = cgiPath.indexOf(".ws");
				String pkg = "socket_action" + cgiPath.substring(0, index);
				handshakeWebSocket(req, pkg, ops, ips);
			}
			ifThisIsFile = new File(realPath);
			if(!ifThisIsFile.exists()) {

				res.setStatusCore(404);
				res.setResponseStr((req.getRowPath() + " was not found"));
				return res;
			}
			res.setStatusCore(200);
			res.setResponseByte(ByteUtil.ByteReadFromFileName(realPath));
			res.setLastModified(ifThisIsFile.lastModified());
		} catch(NoClassDefFoundError e) {
			res.setResponseStr((req.getRowPath() + " was not found"));
			res.setStatusCore(404);
		} catch(ClassNotFoundException e) {
			res.setResponseStr((req.getRowPath() + " was not found"));
			res.setStatusCore(404);
		} catch (Exception e) {
			res.setStatusCore(500);
			Exception ex = (Exception)e.getCause();
			if(ex != null) {
				e = ex;
			}
			String msg = e.getMessage() == null ? e.toString() : e.getMessage();
			res.setResponseStr(msg);
			e.printStackTrace();
		}
		return res;
	}

    private static HttpResponse executeCgi(HttpRequest req, String PackageName)
    		throws Exception{
	    Class<Action> cls = null;

        cls = (Class<Action>)Class.forName(PackageName);
        Method method = cls.getMethod("execute", HttpRequest.class);
        // 実行する
        return (HttpResponse)method.invoke(cls.newInstance(),req);
    }
    private static void  handshakeWebSocket(HttpRequest req, String PackageName, OutputStream ops, InputStream ips) throws Exception {

		StringBuffer sb = new StringBuffer();
		String webSocketVersion = req.getHeader().get("Sec-WebSocket-Version");
		String webSocketProtocol = req.getHeader().get("Sec-websocket-protocol");
		String[] protocols = webSocketProtocol != null ? webSocketProtocol.split(",") : new String[0];
		int wsVersion = 0;
		if(!"".equals(webSocketVersion)) {
			wsVersion = Integer.parseInt(webSocketVersion);
		}

		String path = req.getRowPath();
		String key1 = req.getHeader().get("Sec-WebSocket-Key").trim();

		MessageDigest md = MessageDigest.getInstance("SHA1");
		md.update((key1 + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes());
		byte[] hash = md.digest();
		String returnKey = new BASE64Encoder().encode(hash);

		sb.append("HTTP/1.1 101 Switching Protocol\r\n");
		sb.append("Upgrade: websocket\r\n");
		sb.append("Connection: Upgrade\r\n");
		sb.append("Sec-WebSocket-Accept: " + returnKey + "\r\n");
		if(protocols.length > 0) {
			sb.append("Sec-WebSocket-Protocol: " + protocols[0] + "\r\n");
		}
		sb.append("\r\n");
		ops.write(sb.toString().getBytes());

	    Class<WebSocketFrame> cls = null;

		cls = (Class<WebSocketFrame>)Class.forName(PackageName);
		WebSocketFrame class2 = cls.newInstance();
		Method method = cls.getMethod("setStream", OutputStream.class, InputStream.class);
		// 実行する
		method.invoke(class2, ops, ips);

		method = cls.getMethod("execute", HttpRequest.class);
		// 実行する
		method.invoke(class2, req);
	}
}
